package nemosofts.voxradio.adapter;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.Filter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.nemosofts.theme.ColorUtils;
import androidx.nemosofts.view.RoundedImageView;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.like.LikeButton;
import com.like.OnLikeListener;
import com.squareup.picasso.Picasso;
import com.startapp.sdk.ads.nativead.NativeAdPreferences;
import com.startapp.sdk.ads.nativead.StartAppNativeAd;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import es.claucookie.miniequalizerlibrary.EqualizerView;
import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.asyncTask.LoadStatus;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.dialog.FeedBackDialog;
import nemosofts.voxradio.dialog.ReviewDialog;
import nemosofts.voxradio.interfaces.SuccessListener;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.SharedPref;
import nemosofts.voxradio.utils.helper.Helper;

@SuppressWarnings("deprecation")
public class AdapterRadioList extends RecyclerView.Adapter {

    private final Context context;
    private List<ItemRadio> arrayList;
    private final List<ItemRadio> filteredArrayList;
    private final RecyclerItemClickListener listener;
    private NameFilter filter;
    private final Helper helper;
    private final SharedPref sharedPref;
    private final int VIEW_PROG = -1;
    Boolean isAdLoaded = false;
    List<NativeAd> mNativeAdsAdmob = new ArrayList<>();

    public AdapterRadioList(Context context, List<ItemRadio> arrayList, RecyclerItemClickListener clickListener) {
        this.arrayList = arrayList;
        this.filteredArrayList = arrayList;
        this.context = context;
        this.listener = clickListener;
        helper = new Helper(context);
        sharedPref = new SharedPref(context);
    }

    static class MyViewHolder extends RecyclerView.ViewHolder {

        private final RelativeLayout rl_radio_list;
        private final RoundedImageView iv_radio_list;
        private final EqualizerView equalizer;
        private final TextView radioTitle,catName, tv_avg_rate, tv_views;
        private final RatingBar ratingBar;
        private final ImageView iv_list_option;
        private final LikeButton likeButton;
        private final RelativeLayout rl_native_ad;

        MyViewHolder(View view) {
            super(view);
            rl_radio_list = view.findViewById(R.id.rl_radio_list);
            iv_radio_list = view.findViewById(R.id.iv_radio_list);
            equalizer = view.findViewById(R.id.equalizer_radio_list);
            radioTitle = view.findViewById(R.id.tv_radio_list_name);
            catName = view.findViewById(R.id.tv_radio_list_cat);
            ratingBar = view.findViewById(R.id.rb_radio_list);
            tv_avg_rate = view.findViewById(R.id.tv_radio_list_avg_rate);
            tv_views = view.findViewById(R.id.tv_radio_list_views);
            likeButton = itemView.findViewById(R.id.iv_radio_fav_list);
            iv_list_option = view.findViewById(R.id.iv_list_option);

            rl_native_ad = view.findViewById(R.id.rl_native_ad);
        }
    }

    private static class ProgressViewHolder extends RecyclerView.ViewHolder {
        @SuppressLint("StaticFieldLeak")
        private static ProgressBar progressBar;
        private ProgressViewHolder(View v) {
            super(v);
            progressBar = v.findViewById(R.id.progressBar);
        }
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == VIEW_PROG) {
            View v = LayoutInflater.from(parent.getContext()).inflate(R.layout.row_progressbar, parent, false);
            return new ProgressViewHolder(v);
        } else {
            View itemView = LayoutInflater.from(parent.getContext()).inflate(R.layout.item_row_radio_vertical, parent, false);
            return new MyViewHolder(itemView);
        }
    }

    @Override
    public void onBindViewHolder(@NonNull final RecyclerView.ViewHolder holder, final int position) {
        if (holder instanceof MyViewHolder) {

            ((MyViewHolder) holder).radioTitle.setText(arrayList.get(position).getRadioTitle());
            ((MyViewHolder) holder).catName.setText(arrayList.get(position).getCategoryName());
            ((MyViewHolder) holder).likeButton.setLiked(arrayList.get(position).IsFav());
            ((MyViewHolder) holder).tv_views.setText(ApplicationUtil.format(Integer.valueOf(arrayList.get(position).getTotalViews())));

            Picasso.get()
                    .load(arrayList.get(position).getImage())
                    .resize(300,300)
                    .placeholder(R.drawable.material_design_default)
                    .into(((MyViewHolder) holder).iv_radio_list);

            ((MyViewHolder) holder).tv_avg_rate.setTypeface(((MyViewHolder) holder).tv_avg_rate.getTypeface(), Typeface.BOLD);
            ((MyViewHolder) holder).tv_avg_rate.setText(arrayList.get(position).getAverageRating());
            ((MyViewHolder) holder).ratingBar.setRating(Float.parseFloat(arrayList.get(position).getAverageRating()));

            if (PlayerService.getIsPlayling() && Callback.playPos <= holder.getAbsoluteAdapterPosition() && Callback.arrayList_play.get(Callback.playPos).getId().equals(arrayList.get(position).getId()) && Boolean.TRUE.equals(Callback.isRadio)) {
                ((MyViewHolder) holder).equalizer.setVisibility(View.VISIBLE);
                ((MyViewHolder) holder).equalizer.animateBars();

                ((MyViewHolder) holder).rl_radio_list.setBackgroundColor(ColorUtils.colorAccent50(context));
                ((MyViewHolder) holder).radioTitle.setTextColor(ColorUtils.colorAccent(context));

            } else {
                ((MyViewHolder) holder).equalizer.setVisibility(View.GONE);
                ((MyViewHolder) holder).equalizer.stopBars();

                ((MyViewHolder) holder).rl_radio_list.setBackgroundColor(ContextCompat.getColor(context, android.R.color.transparent));
                ((MyViewHolder) holder).radioTitle.setTextColor(ColorUtils.colorTitle(context));
            }

            ((MyViewHolder) holder).rl_radio_list.setOnClickListener(view -> {
                try {
                    listener.onClick(getPosition(arrayList.get(holder.getAbsoluteAdapterPosition()).getId()));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            ((MyViewHolder) holder).iv_list_option.setOnClickListener(view -> {
                try {
                    openBottomSheet(holder.getAbsoluteAdapterPosition());
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });

            if(sharedPref.isLogged()) {
                ((MyViewHolder) holder).likeButton.setOnLikeListener(new OnLikeListener() {
                    @Override
                    public void liked(LikeButton likeButton) {
                        try {
                            loadFav(holder.getAbsoluteAdapterPosition());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    public void unLiked(LikeButton likeButton) {
                        try {
                            loadFav(holder.getAbsoluteAdapterPosition());
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                ((MyViewHolder) holder).likeButton.setOnClickListener(view -> {
                    if(!sharedPref.isLogged()) {
                        helper.clickLogin();
                    }
                });
            }

            if (Boolean.TRUE.equals(Callback.isNativeAd && (position != arrayList.size() - 1) && (position + 1) % Callback.nativeAdShow == 0)) {
                try {
                    if (((MyViewHolder) holder).rl_native_ad.getChildCount() == 0) {
                        switch (Callback.adNetwork) {
                            case Callback.AD_TYPE_ADMOB:
                            case Callback.AD_TYPE_FACEBOOK:
                                if (Boolean.TRUE.equals(isAdLoaded) && (mNativeAdsAdmob.size() >= 5)) {

                                    int i = ApplicationUtil.getRandom(mNativeAdsAdmob.size() - 1);

                                    @SuppressLint("InflateParams") NativeAdView adView = (NativeAdView) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_admob, null);
                                    populateUnifiedNativeAdView(mNativeAdsAdmob.get(i), adView);
                                    ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                    ((MyViewHolder) holder).rl_native_ad.addView(adView);

                                    ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                }
                                break;
                            case Callback.AD_TYPE_STARTAPP:
                                StartAppNativeAd nativeAd = new StartAppNativeAd(context);

                                nativeAd.loadAd(new NativeAdPreferences()
                                        .setAdsNumber(1)
                                        .setAutoBitmapDownload(true)
                                        .setPrimaryImageSize(2), new AdEventListener() {
                                    @Override
                                    public void onReceiveAd(@NonNull Ad ad) {
                                        try {
                                            if (!nativeAd.getNativeAds().isEmpty()) {
                                                @SuppressLint("InflateParams") RelativeLayout nativeAdView = (RelativeLayout) ((Activity) context).getLayoutInflater().inflate(R.layout.layout_native_ad_startapp, null);

                                                ImageView icon = nativeAdView.findViewById(R.id.icon);
                                                TextView title = nativeAdView.findViewById(R.id.title);
                                                TextView description = nativeAdView.findViewById(R.id.description);
                                                Button button = nativeAdView.findViewById(R.id.button);

                                                Picasso.get()
                                                        .load(nativeAd.getNativeAds().get(0).getImageUrl())
                                                        .into(icon);
                                                title.setText(nativeAd.getNativeAds().get(0).getTitle());
                                                description.setText(nativeAd.getNativeAds().get(0).getDescription());
                                                button.setText(nativeAd.getNativeAds().get(0).isApp() ? "Install" : "Open");

                                                ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                                ((MyViewHolder) holder).rl_native_ad.addView(nativeAdView);
                                                ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                            }
                                        } catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }

                                    @Override
                                    public void onFailedToReceiveAd(Ad ad) {
                                    }
                                });
                                break;
                                case Callback.AD_TYPE_IRONSOURCE:
                                    IronSource.init(context, Callback.ironAdsId, IronSource.AD_UNIT.BANNER);
                                    IronSourceBannerLayout banner = IronSource.createBanner((Activity) context, ISBannerSize.BANNER);
                                    banner.setBannerListener(new com.ironsource.mediationsdk.sdk.BannerListener() {
                                        @Override
                                        public void onBannerAdLoaded() {
                                            ((MyViewHolder) holder).rl_native_ad.removeAllViews();
                                            ((MyViewHolder) holder).rl_native_ad.addView(banner);

                                            ((MyViewHolder) holder).rl_native_ad.setVisibility(View.VISIBLE);
                                        }

                                        @Override
                                        public void onBannerAdLoadFailed(IronSourceError error) {

                                        }

                                        @Override
                                        public void onBannerAdClicked() {
                                        }

                                        @Override
                                        public void onBannerAdScreenPresented() {
                                        }

                                        @Override
                                        public void onBannerAdScreenDismissed() {
                                        }

                                        @Override
                                        public void onBannerAdLeftApplication() {
                                        }
                                    });
                                    IronSource.loadBanner(banner);
                                break;
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public long getItemId(int id) {
        return id;
    }

    @Override
    public int getItemCount() {
        return arrayList.size();
    }

    @Override
    public int getItemViewType(int position) {
        if (arrayList.get(position) != null) {
            return position;
        } else {
            return VIEW_PROG;
        }
    }

    private int getPosition(String id) {
        int count = 0;
        for (int i = 0; i < filteredArrayList.size(); i++) {
            if (id.equals(filteredArrayList.get(i).getId())) {
                count = i;
                break;
            }
        }
        return count;
    }

    public Filter getFilter() {
        if (filter == null) {
            filter = new NameFilter();
        }
        return filter;
    }

    private class NameFilter extends Filter {

        @Override
        protected FilterResults performFiltering(CharSequence constraint) {

            constraint = constraint.toString().toLowerCase();
            FilterResults result = new FilterResults();
            if (constraint.toString().length() > 0) {
                ArrayList<ItemRadio> filteredItems = new ArrayList<>();

                for (int i = 0, l = filteredArrayList.size(); i < l; i++) {
                    String nameList = filteredArrayList.get(i).getRadioTitle();
                    if (nameList.toLowerCase().contains(constraint))
                        filteredItems.add(filteredArrayList.get(i));
                }
                result.count = filteredItems.size();
                result.values = filteredItems;
            } else {
                synchronized (this) {
                    result.values = filteredArrayList;
                    result.count = filteredArrayList.size();
                }
            }
            return result;
        }

        @SuppressLint("NotifyDataSetChanged")
        @SuppressWarnings("unchecked")
        @Override
        protected void publishResults(CharSequence constraint, FilterResults results) {
            arrayList = (ArrayList<ItemRadio>) results.values;
            notifyDataSetChanged();
        }
    }

    private void loadFav( int adapterPosition) {
        if(sharedPref.isLogged()) {
            if (helper.isNetworkAvailable()) {
                LoadStatus loadFav = new LoadStatus(new SuccessListener() {
                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void onEnd(String success, String favSuccess, String message) {
                        if (success.equals("1")) {
                            arrayList.get(adapterPosition).setIsFav(message.equals("Added to Favourite"));
                            notifyItemChanged(adapterPosition);
                            Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                        } else {
                            Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
                        }
                    }
                }, helper.getAPIRequest(Callback.METHOD_DO_FAV, 0, arrayList.get(adapterPosition).getId(), "", "", "", sharedPref.getUserId(), "", "", "", "", "", "", "radio", null));
                loadFav.execute();
            } else {
                Toast.makeText(context, context.getString(R.string.err_internet_not_connected), Toast.LENGTH_SHORT).show();
            }
        } else {
            if(!sharedPref.isLogged()) {
                helper.clickLogin();
            }
        }
    }

    @SuppressLint("UseCompatLoadingForDrawables")
    private void openBottomSheet(int adapterPosition) {
        LayoutInflater inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        @SuppressLint("InflateParams") View view = inflater.inflate(R.layout.bottom_sheet_radio, null);

        BottomSheetDialog dialog = new BottomSheetDialog(context);
        dialog.setContentView(view);

        TextView tv_sheet_text = dialog.findViewById(R.id.tv_sheet_text);
        TextView tv_sheet_list_cat = dialog.findViewById(R.id.tv_sheet_list_cat);
        RoundedImageView iv_sheet_post = dialog.findViewById(R.id.iv_sheet_post);

        LinearLayout ll_sheet_report = dialog.findViewById(R.id.ll_sheet_report);
        LinearLayout ll_sheet_share = dialog.findViewById(R.id.ll_sheet_share);
        LinearLayout ll_sheet_fav = dialog.findViewById(R.id.ll_sheet_fav);
        LinearLayout ll_sheet_rating = dialog.findViewById(R.id.ll_sheet_rating);
        LinearLayout ll_sheet_youtube = dialog.findViewById(R.id.ll_sheet_youtube);

        ImageView iv_turned = dialog.findViewById(R.id.iv_turned);
        TextView tv_turned = dialog.findViewById(R.id.tv_turned);
        if (iv_turned != null && tv_turned != null){
            if (Boolean.TRUE.equals(arrayList.get(adapterPosition).IsFav())) {
                tv_turned.setText(context.getResources().getString(R.string.un_favourite));
                iv_turned.setImageDrawable(context.getResources().getDrawable(R.drawable.ic_turned_in,null));
            } else {
                tv_turned.setText(context.getResources().getString(R.string.add_favourite));
                iv_turned.setImageDrawable(context.getResources().getDrawable(R.drawable.ic_turned_in_not,null));
            }
        }

        if (iv_sheet_post != null){
            Picasso.get()
                    .load(arrayList.get(adapterPosition).getImage())
                    .centerCrop()
                    .resize(300,300)
                    .placeholder(R.drawable.material_design_default)
                    .into(iv_sheet_post);
        }

        Objects.requireNonNull(tv_sheet_list_cat).setText(arrayList.get(adapterPosition).getCategoryName());
        Objects.requireNonNull(tv_sheet_text).setText(arrayList.get(adapterPosition).getRadioTitle());
        Objects.requireNonNull(ll_sheet_report).setOnClickListener(view2 -> {
            new FeedBackDialog((Activity) context).showDialog(arrayList.get(adapterPosition).getId(), arrayList.get(adapterPosition).getRadioTitle());
            dialog.dismiss();
        });
        Objects.requireNonNull(ll_sheet_share).setOnClickListener(view3 -> {
            Intent sharingIntent = new Intent(Intent.ACTION_SEND);
            sharingIntent.setType("text/plain");
            sharingIntent.putExtra(Intent.EXTRA_SUBJECT, context.getResources().getString(R.string.share_radio));
            sharingIntent.putExtra(Intent.EXTRA_TEXT, context.getResources().getString(R.string.listening) + " - " + arrayList.get(adapterPosition).getRadioTitle() + "\n\nvia " + context.getResources().getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + context.getPackageName());
            context.startActivity(Intent.createChooser(sharingIntent, context.getResources().getString(R.string.share_radio)));
        });
        Objects.requireNonNull(ll_sheet_fav).setOnClickListener(view4 -> {
            loadFav(adapterPosition);
            dialog.dismiss();
        });
        Objects.requireNonNull(ll_sheet_rating).setOnClickListener(view5 -> {
            ReviewDialog reviewDialog = new ReviewDialog((Activity) context, new ReviewDialog.RatingDialogListener() {
                @Override
                public void onShow() {

                }

                @Override
                public void onGetRating(String rating, String message) {
                    arrayList.get(adapterPosition).setUserRating(String.valueOf(rating));
                    arrayList.get(adapterPosition).setUserMessage(message);
                }

                @Override
                public void onDismiss(String success, String rateSuccess, String message, int rating, String userRating, String userMessage) {
                    if (success.equals("1")) {
                        if (rateSuccess.equals("1")) {
                            try {
                                arrayList.get(adapterPosition).setAverageRating(String.valueOf(rating));
                                arrayList.get(adapterPosition).setTotalRate(String.valueOf(Integer.parseInt(arrayList.get(adapterPosition).getTotalRate() + 1)));
                                arrayList.get(adapterPosition).setUserRating(String.valueOf(userRating));
                                arrayList.get(adapterPosition).setUserMessage(String.valueOf(userMessage));
                                notifyItemChanged(adapterPosition);
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Toast.makeText(context, message, Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(context, context.getString(R.string.err_server_not_connected), Toast.LENGTH_SHORT).show();
                    }
                }
            });
            reviewDialog.showDialog(arrayList.get(adapterPosition).getId(), arrayList.get(adapterPosition).getUserRating(), arrayList.get(adapterPosition).getUserMessage());
            dialog.dismiss();
        });
        Objects.requireNonNull(ll_sheet_youtube).setOnClickListener(view6 -> {
            Intent intent = new Intent(Intent.ACTION_SEARCH);
            intent.setPackage("com.google.android.youtube");
            intent.putExtra("query", arrayList.get(adapterPosition).getRadioTitle());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            context.startActivity(intent);
            dialog.dismiss();
        });
        dialog.show();
    }

    public void addAds(List<NativeAd> arrayListNativeAds) {
        isAdLoaded = true;
        mNativeAdsAdmob.addAll(arrayListNativeAds);
        for (int i = 0; i < arrayList.size(); i++) {
            if(arrayList.get(i) == null) {
                notifyItemChanged(i);
            }
        }
    }

    private void populateUnifiedNativeAdView(NativeAd nativeAd, NativeAdView adView) {
        MediaView mediaView = adView.findViewById(R.id.ad_media);
        adView.setMediaView(mediaView);

        // Set other ad assets.
        adView.setHeadlineView(adView.findViewById(R.id.ad_headline));
        adView.setBodyView(adView.findViewById(R.id.ad_body));
        adView.setCallToActionView(adView.findViewById(R.id.ad_call_to_action));
        adView.setIconView(adView.findViewById(R.id.ad_icon));
        adView.setPriceView(adView.findViewById(R.id.ad_price));
        adView.setStarRatingView(adView.findViewById(R.id.ad_stars));
        adView.setStoreView(adView.findViewById(R.id.ad_store));
        adView.setAdvertiserView(adView.findViewById(R.id.ad_advertiser));

        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) Objects.requireNonNull(adView.getHeadlineView())).setText(nativeAd.getHeadline());

        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
        if (nativeAd.getBody() == null) {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getBodyView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
        }

        if (nativeAd.getCallToAction() == null) {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getCallToActionView()).setVisibility(View.VISIBLE);
            ((Button) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
        }

        if (nativeAd.getIcon() == null) {
            Objects.requireNonNull(adView.getIconView()).setVisibility(View.GONE);
        } else {
            ((ImageView) Objects.requireNonNull(adView.getIconView())).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getPrice() == null) {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getPriceView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
        }

        if (nativeAd.getStore() == null) {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.INVISIBLE);
        } else {
            Objects.requireNonNull(adView.getStoreView()).setVisibility(View.VISIBLE);
            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
        }

        if (nativeAd.getStarRating() == null) {
            Objects.requireNonNull(adView.getStarRatingView()).setVisibility(View.INVISIBLE);
        } else {
            ((RatingBar) Objects.requireNonNull(adView.getStarRatingView()))
                    .setRating(nativeAd.getStarRating().floatValue());
            adView.getStarRatingView().setVisibility(View.VISIBLE);
        }

        if (nativeAd.getAdvertiser() == null) {
            Objects.requireNonNull(adView.getAdvertiserView()).setVisibility(View.INVISIBLE);
        } else {
            ((TextView) Objects.requireNonNull(adView.getAdvertiserView())).setText(nativeAd.getAdvertiser());
            adView.getAdvertiserView().setVisibility(View.VISIBLE);
        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad. The SDK will populate the adView's MediaView
        // with the media content from this native ad.
        adView.setNativeAd(nativeAd);
    }

    public interface RecyclerItemClickListener{
        void onClick(int position);
    }

}